package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.DySalesOrderDetail;
import com.xforceplus.ultraman.app.policymanagement.service.IDySalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-06
 */
@RestController
public class DySalesOrderDetailController {

  @Autowired
  private IDySalesOrderDetailService dySalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dySalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/dysalesorderdetails" )
  public XfR getDySalesOrderDetails(XfPage page, DySalesOrderDetail dySalesOrderDetail) {
    return XfR.ok(dySalesOrderDetailServiceImpl.page(page, Wrappers.query(dySalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dysalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dySalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dySalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/dysalesorderdetails")
  public XfR save(@RequestBody DySalesOrderDetail dySalesOrderDetail) {
     return XfR.ok(dySalesOrderDetailServiceImpl.save(dySalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dySalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/dysalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody DySalesOrderDetail dySalesOrderDetail,@PathVariable Long id) {
      dySalesOrderDetail.setId(id);
      return XfR.ok(dySalesOrderDetailServiceImpl.updateById(dySalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dySalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dysalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody DySalesOrderDetail dySalesOrderDetail,@PathVariable Long id) {
      DySalesOrderDetail updySalesOrderDetail = dySalesOrderDetailServiceImpl.getById(id);
      if(updySalesOrderDetail != null){
        updySalesOrderDetail = ObjectCopyUtils.copyProperties(dySalesOrderDetail,updySalesOrderDetail,true);
      }
      return XfR.ok(dySalesOrderDetailServiceImpl.updateById(updySalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dysalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dySalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/dysalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dy_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(dySalesOrderDetailServiceImpl.querys(params));
  }

}
