package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.JdSettlement;
import com.xforceplus.ultraman.app.policymanagement.service.IJdSettlementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 京东结算单前端控制器
 *
 * @author ultraman
 * @date 2024-11-06
 */
@RestController
public class JdSettlementController {

  @Autowired
  private IJdSettlementService jdSettlementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jdSettlement 京东结算单
   * @return
   */
  @GetMapping("/jdsettlements" )
  public XfR getJdSettlements(XfPage page, JdSettlement jdSettlement) {
    return XfR.ok(jdSettlementServiceImpl.page(page, Wrappers.query(jdSettlement)));
  }

  /**
   * 通过id查询京东结算单
   * @param  id
   * @return XfR
   */
  @GetMapping("/jdsettlements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jdSettlementServiceImpl.getById(id));
  }

  /**
   * 新增京东结算单
   * @param jdSettlement 京东结算单
   * @return XfR
   */
  @PostMapping("/jdsettlements")
  public XfR save(@RequestBody JdSettlement jdSettlement) {
     return XfR.ok(jdSettlementServiceImpl.save(jdSettlement));
  }

  /**
   * 修改-传入修改后的全部数据京东结算单
   * @param jdSettlement 京东结算单
   * @return XfR
   */
  @PutMapping("/jdsettlements/{id}")
  public XfR putUpdate(@RequestBody JdSettlement jdSettlement,@PathVariable Long id) {
      jdSettlement.setId(id);
      return XfR.ok(jdSettlementServiceImpl.updateById(jdSettlement));
  }

  /**
   * 修改-传入修改的数据京东结算单
   * @param jdSettlement 京东结算单
   * @return XfR
   */
  @PatchMapping("/jdsettlements/{id}")
  public XfR patchUpdate(@RequestBody JdSettlement jdSettlement,@PathVariable Long id) {
      JdSettlement upjdSettlement = jdSettlementServiceImpl.getById(id);
      if(upjdSettlement != null){
        upjdSettlement = ObjectCopyUtils.copyProperties(jdSettlement,upjdSettlement,true);
      }
      return XfR.ok(jdSettlementServiceImpl.updateById(upjdSettlement));
  }

  /**
   * 通过id删除京东结算单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jdsettlements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jdSettlementServiceImpl.removeById(id));
  }

  @PostMapping("/jdsettlements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jd_settlement");
     params.put("request", condition);

     return XfR.ok(jdSettlementServiceImpl.querys(params));
  }

}
