package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableStatisticsDayDetail;
import com.xforceplus.ultraman.app.policymanagement.service.IReceivableStatisticsDayDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-06
 */
@RestController
public class ReceivableStatisticsDayDetailController {

  @Autowired
  private IReceivableStatisticsDayDetailService receivableStatisticsDayDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableStatisticsDayDetail ${table.comment}
   * @return
   */
  @GetMapping("/receivablestatisticsdaydetails" )
  public XfR getReceivableStatisticsDayDetails(XfPage page, ReceivableStatisticsDayDetail receivableStatisticsDayDetail) {
    return XfR.ok(receivableStatisticsDayDetailServiceImpl.page(page, Wrappers.query(receivableStatisticsDayDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablestatisticsdaydetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableStatisticsDayDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivableStatisticsDayDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivablestatisticsdaydetails")
  public XfR save(@RequestBody ReceivableStatisticsDayDetail receivableStatisticsDayDetail) {
     return XfR.ok(receivableStatisticsDayDetailServiceImpl.save(receivableStatisticsDayDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivableStatisticsDayDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivablestatisticsdaydetails/{id}")
  public XfR putUpdate(@RequestBody ReceivableStatisticsDayDetail receivableStatisticsDayDetail,@PathVariable Long id) {
      receivableStatisticsDayDetail.setId(id);
      return XfR.ok(receivableStatisticsDayDetailServiceImpl.updateById(receivableStatisticsDayDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivableStatisticsDayDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivablestatisticsdaydetails/{id}")
  public XfR patchUpdate(@RequestBody ReceivableStatisticsDayDetail receivableStatisticsDayDetail,@PathVariable Long id) {
      ReceivableStatisticsDayDetail upreceivableStatisticsDayDetail = receivableStatisticsDayDetailServiceImpl.getById(id);
      if(upreceivableStatisticsDayDetail != null){
        upreceivableStatisticsDayDetail = ObjectCopyUtils.copyProperties(receivableStatisticsDayDetail,upreceivableStatisticsDayDetail,true);
      }
      return XfR.ok(receivableStatisticsDayDetailServiceImpl.updateById(upreceivableStatisticsDayDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablestatisticsdaydetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableStatisticsDayDetailServiceImpl.removeById(id));
  }

  @PostMapping("/receivablestatisticsdaydetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_statistics_day_detail");
     params.put("request", condition);

     return XfR.ok(receivableStatisticsDayDetailServiceImpl.querys(params));
  }

}
