package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.Accountingpolicydetail;
import com.xforceplus.ultraman.app.policymanagement.service.IAccountingpolicydetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-31
 */
@RestController
public class AccountingpolicydetailController {

  @Autowired
  private IAccountingpolicydetailService accountingpolicydetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountingpolicydetail ${table.comment}
   * @return
   */
  @GetMapping("/accountingpolicydetails" )
  public XfR getAccountingpolicydetails(XfPage page, Accountingpolicydetail accountingpolicydetail) {
    return XfR.ok(accountingpolicydetailServiceImpl.page(page, Wrappers.query(accountingpolicydetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountingpolicydetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountingpolicydetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountingpolicydetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountingpolicydetails")
  public XfR save(@RequestBody Accountingpolicydetail accountingpolicydetail) {
     return XfR.ok(accountingpolicydetailServiceImpl.save(accountingpolicydetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountingpolicydetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountingpolicydetails/{id}")
  public XfR putUpdate(@RequestBody Accountingpolicydetail accountingpolicydetail,@PathVariable Long id) {
      accountingpolicydetail.setId(id);
      return XfR.ok(accountingpolicydetailServiceImpl.updateById(accountingpolicydetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountingpolicydetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountingpolicydetails/{id}")
  public XfR patchUpdate(@RequestBody Accountingpolicydetail accountingpolicydetail,@PathVariable Long id) {
      Accountingpolicydetail upaccountingpolicydetail = accountingpolicydetailServiceImpl.getById(id);
      if(upaccountingpolicydetail != null){
        upaccountingpolicydetail = ObjectCopyUtils.copyProperties(accountingpolicydetail,upaccountingpolicydetail,true);
      }
      return XfR.ok(accountingpolicydetailServiceImpl.updateById(upaccountingpolicydetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountingpolicydetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountingpolicydetailServiceImpl.removeById(id));
  }

  @PostMapping("/accountingpolicydetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "accountingpolicydetail");
     params.put("request", condition);

     return XfR.ok(accountingpolicydetailServiceImpl.querys(params));
  }

}
