package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.KsCheck;
import com.xforceplus.ultraman.app.policymanagement.service.IKsCheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 快手账单前端控制器
 *
 * @author ultraman
 * @date 2024-10-31
 */
@RestController
public class KsCheckController {

  @Autowired
  private IKsCheckService ksCheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ksCheck 快手账单
   * @return
   */
  @GetMapping("/kschecks" )
  public XfR getKsChecks(XfPage page, KsCheck ksCheck) {
    return XfR.ok(ksCheckServiceImpl.page(page, Wrappers.query(ksCheck)));
  }

  /**
   * 通过id查询快手账单
   * @param  id
   * @return XfR
   */
  @GetMapping("/kschecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ksCheckServiceImpl.getById(id));
  }

  /**
   * 新增快手账单
   * @param ksCheck 快手账单
   * @return XfR
   */
  @PostMapping("/kschecks")
  public XfR save(@RequestBody KsCheck ksCheck) {
     return XfR.ok(ksCheckServiceImpl.save(ksCheck));
  }

  /**
   * 修改-传入修改后的全部数据快手账单
   * @param ksCheck 快手账单
   * @return XfR
   */
  @PutMapping("/kschecks/{id}")
  public XfR putUpdate(@RequestBody KsCheck ksCheck,@PathVariable Long id) {
      ksCheck.setId(id);
      return XfR.ok(ksCheckServiceImpl.updateById(ksCheck));
  }

  /**
   * 修改-传入修改的数据快手账单
   * @param ksCheck 快手账单
   * @return XfR
   */
  @PatchMapping("/kschecks/{id}")
  public XfR patchUpdate(@RequestBody KsCheck ksCheck,@PathVariable Long id) {
      KsCheck upksCheck = ksCheckServiceImpl.getById(id);
      if(upksCheck != null){
        upksCheck = ObjectCopyUtils.copyProperties(ksCheck,upksCheck,true);
      }
      return XfR.ok(ksCheckServiceImpl.updateById(upksCheck));
  }

  /**
   * 通过id删除快手账单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/kschecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ksCheckServiceImpl.removeById(id));
  }

  @PostMapping("/kschecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ks_check");
     params.put("request", condition);

     return XfR.ok(ksCheckServiceImpl.querys(params));
  }

}
