package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.OmsAfterSale;
import com.xforceplus.ultraman.app.policymanagement.service.IOmsAfterSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 网店管家OMS售后前端控制器
 *
 * @author ultraman
 * @date 2024-10-31
 */
@RestController
public class OmsAfterSaleController {

  @Autowired
  private IOmsAfterSaleService omsAfterSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omsAfterSale 网店管家OMS售后
   * @return
   */
  @GetMapping("/omsaftersales" )
  public XfR getOmsAfterSales(XfPage page, OmsAfterSale omsAfterSale) {
    return XfR.ok(omsAfterSaleServiceImpl.page(page, Wrappers.query(omsAfterSale)));
  }

  /**
   * 通过id查询网店管家OMS售后
   * @param  id
   * @return XfR
   */
  @GetMapping("/omsaftersales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omsAfterSaleServiceImpl.getById(id));
  }

  /**
   * 新增网店管家OMS售后
   * @param omsAfterSale 网店管家OMS售后
   * @return XfR
   */
  @PostMapping("/omsaftersales")
  public XfR save(@RequestBody OmsAfterSale omsAfterSale) {
     return XfR.ok(omsAfterSaleServiceImpl.save(omsAfterSale));
  }

  /**
   * 修改-传入修改后的全部数据网店管家OMS售后
   * @param omsAfterSale 网店管家OMS售后
   * @return XfR
   */
  @PutMapping("/omsaftersales/{id}")
  public XfR putUpdate(@RequestBody OmsAfterSale omsAfterSale,@PathVariable Long id) {
      omsAfterSale.setId(id);
      return XfR.ok(omsAfterSaleServiceImpl.updateById(omsAfterSale));
  }

  /**
   * 修改-传入修改的数据网店管家OMS售后
   * @param omsAfterSale 网店管家OMS售后
   * @return XfR
   */
  @PatchMapping("/omsaftersales/{id}")
  public XfR patchUpdate(@RequestBody OmsAfterSale omsAfterSale,@PathVariable Long id) {
      OmsAfterSale upomsAfterSale = omsAfterSaleServiceImpl.getById(id);
      if(upomsAfterSale != null){
        upomsAfterSale = ObjectCopyUtils.copyProperties(omsAfterSale,upomsAfterSale,true);
      }
      return XfR.ok(omsAfterSaleServiceImpl.updateById(upomsAfterSale));
  }

  /**
   * 通过id删除网店管家OMS售后
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/omsaftersales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omsAfterSaleServiceImpl.removeById(id));
  }

  @PostMapping("/omsaftersales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oms_after_sale");
     params.put("request", condition);

     return XfR.ok(omsAfterSaleServiceImpl.querys(params));
  }

}
