package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.TbCheck;
import com.xforceplus.ultraman.app.policymanagement.service.ITbCheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 淘宝账单前端控制器
 *
 * @author ultraman
 * @date 2024-11-12
 */
@RestController
public class TbCheckController {

  @Autowired
  private ITbCheckService tbCheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tbCheck 淘宝账单
   * @return
   */
  @GetMapping("/tbchecks" )
  public XfR getTbChecks(XfPage page, TbCheck tbCheck) {
    return XfR.ok(tbCheckServiceImpl.page(page, Wrappers.query(tbCheck)));
  }

  /**
   * 通过id查询淘宝账单
   * @param  id
   * @return XfR
   */
  @GetMapping("/tbchecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tbCheckServiceImpl.getById(id));
  }

  /**
   * 新增淘宝账单
   * @param tbCheck 淘宝账单
   * @return XfR
   */
  @PostMapping("/tbchecks")
  public XfR save(@RequestBody TbCheck tbCheck) {
     return XfR.ok(tbCheckServiceImpl.save(tbCheck));
  }

  /**
   * 修改-传入修改后的全部数据淘宝账单
   * @param tbCheck 淘宝账单
   * @return XfR
   */
  @PutMapping("/tbchecks/{id}")
  public XfR putUpdate(@RequestBody TbCheck tbCheck,@PathVariable Long id) {
      tbCheck.setId(id);
      return XfR.ok(tbCheckServiceImpl.updateById(tbCheck));
  }

  /**
   * 修改-传入修改的数据淘宝账单
   * @param tbCheck 淘宝账单
   * @return XfR
   */
  @PatchMapping("/tbchecks/{id}")
  public XfR patchUpdate(@RequestBody TbCheck tbCheck,@PathVariable Long id) {
      TbCheck uptbCheck = tbCheckServiceImpl.getById(id);
      if(uptbCheck != null){
        uptbCheck = ObjectCopyUtils.copyProperties(tbCheck,uptbCheck,true);
      }
      return XfR.ok(tbCheckServiceImpl.updateById(uptbCheck));
  }

  /**
   * 通过id删除淘宝账单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tbchecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tbCheckServiceImpl.removeById(id));
  }

  @PostMapping("/tbchecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tb_check");
     params.put("request", condition);

     return XfR.ok(tbCheckServiceImpl.querys(params));
  }

}
