package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.AfterSalesOrderCheckResultItem;
import com.xforceplus.ultraman.app.policymanagement.service.IAfterSalesOrderCheckResultItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 售后单对账结果关系前端控制器
 *
 * @author ultraman
 * @date 2024-11-12
 */
@RestController
public class AfterSalesOrderCheckResultItemController {

  @Autowired
  private IAfterSalesOrderCheckResultItemService afterSalesOrderCheckResultItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param afterSalesOrderCheckResultItem 售后单对账结果关系
   * @return
   */
  @GetMapping("/aftersalesordercheckresultitems" )
  public XfR getAfterSalesOrderCheckResultItems(XfPage page, AfterSalesOrderCheckResultItem afterSalesOrderCheckResultItem) {
    return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.page(page, Wrappers.query(afterSalesOrderCheckResultItem)));
  }

  /**
   * 通过id查询售后单对账结果关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/aftersalesordercheckresultitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.getById(id));
  }

  /**
   * 新增售后单对账结果关系
   * @param afterSalesOrderCheckResultItem 售后单对账结果关系
   * @return XfR
   */
  @PostMapping("/aftersalesordercheckresultitems")
  public XfR save(@RequestBody AfterSalesOrderCheckResultItem afterSalesOrderCheckResultItem) {
     return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.save(afterSalesOrderCheckResultItem));
  }

  /**
   * 修改-传入修改后的全部数据售后单对账结果关系
   * @param afterSalesOrderCheckResultItem 售后单对账结果关系
   * @return XfR
   */
  @PutMapping("/aftersalesordercheckresultitems/{id}")
  public XfR putUpdate(@RequestBody AfterSalesOrderCheckResultItem afterSalesOrderCheckResultItem,@PathVariable Long id) {
      afterSalesOrderCheckResultItem.setId(id);
      return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.updateById(afterSalesOrderCheckResultItem));
  }

  /**
   * 修改-传入修改的数据售后单对账结果关系
   * @param afterSalesOrderCheckResultItem 售后单对账结果关系
   * @return XfR
   */
  @PatchMapping("/aftersalesordercheckresultitems/{id}")
  public XfR patchUpdate(@RequestBody AfterSalesOrderCheckResultItem afterSalesOrderCheckResultItem,@PathVariable Long id) {
      AfterSalesOrderCheckResultItem upafterSalesOrderCheckResultItem = afterSalesOrderCheckResultItemServiceImpl.getById(id);
      if(upafterSalesOrderCheckResultItem != null){
        upafterSalesOrderCheckResultItem = ObjectCopyUtils.copyProperties(afterSalesOrderCheckResultItem,upafterSalesOrderCheckResultItem,true);
      }
      return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.updateById(upafterSalesOrderCheckResultItem));
  }

  /**
   * 通过id删除售后单对账结果关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aftersalesordercheckresultitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.removeById(id));
  }

  @PostMapping("/aftersalesordercheckresultitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "after_sales_order_check_result_item");
     params.put("request", condition);

     return XfR.ok(afterSalesOrderCheckResultItemServiceImpl.querys(params));
  }

}
