package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SalesOrderCheckResult;
import com.xforceplus.ultraman.app.policymanagement.service.ISalesOrderCheckResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销售订单对账结果前端控制器
 *
 * @author ultraman
 * @date 2024-11-12
 */
@RestController
public class SalesOrderCheckResultController {

  @Autowired
  private ISalesOrderCheckResultService salesOrderCheckResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesOrderCheckResult 销售订单对账结果
   * @return
   */
  @GetMapping("/salesordercheckresults" )
  public XfR getSalesOrderCheckResults(XfPage page, SalesOrderCheckResult salesOrderCheckResult) {
    return XfR.ok(salesOrderCheckResultServiceImpl.page(page, Wrappers.query(salesOrderCheckResult)));
  }

  /**
   * 通过id查询销售订单对账结果
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesordercheckresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesOrderCheckResultServiceImpl.getById(id));
  }

  /**
   * 新增销售订单对账结果
   * @param salesOrderCheckResult 销售订单对账结果
   * @return XfR
   */
  @PostMapping("/salesordercheckresults")
  public XfR save(@RequestBody SalesOrderCheckResult salesOrderCheckResult) {
     return XfR.ok(salesOrderCheckResultServiceImpl.save(salesOrderCheckResult));
  }

  /**
   * 修改-传入修改后的全部数据销售订单对账结果
   * @param salesOrderCheckResult 销售订单对账结果
   * @return XfR
   */
  @PutMapping("/salesordercheckresults/{id}")
  public XfR putUpdate(@RequestBody SalesOrderCheckResult salesOrderCheckResult,@PathVariable Long id) {
      salesOrderCheckResult.setId(id);
      return XfR.ok(salesOrderCheckResultServiceImpl.updateById(salesOrderCheckResult));
  }

  /**
   * 修改-传入修改的数据销售订单对账结果
   * @param salesOrderCheckResult 销售订单对账结果
   * @return XfR
   */
  @PatchMapping("/salesordercheckresults/{id}")
  public XfR patchUpdate(@RequestBody SalesOrderCheckResult salesOrderCheckResult,@PathVariable Long id) {
      SalesOrderCheckResult upsalesOrderCheckResult = salesOrderCheckResultServiceImpl.getById(id);
      if(upsalesOrderCheckResult != null){
        upsalesOrderCheckResult = ObjectCopyUtils.copyProperties(salesOrderCheckResult,upsalesOrderCheckResult,true);
      }
      return XfR.ok(salesOrderCheckResultServiceImpl.updateById(upsalesOrderCheckResult));
  }

  /**
   * 通过id删除销售订单对账结果
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesordercheckresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesOrderCheckResultServiceImpl.removeById(id));
  }

  @PostMapping("/salesordercheckresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_order_check_result");
     params.put("request", condition);

     return XfR.ok(salesOrderCheckResultServiceImpl.querys(params));
  }

}
