package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.JkyOmsOrderDetail;
import com.xforceplus.ultraman.app.policymanagement.service.IJkyOmsOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-13
 */
@RestController
public class JkyOmsOrderDetailController {

  @Autowired
  private IJkyOmsOrderDetailService jkyOmsOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jkyOmsOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/jkyomsorderdetails" )
  public XfR getJkyOmsOrderDetails(XfPage page, JkyOmsOrderDetail jkyOmsOrderDetail) {
    return XfR.ok(jkyOmsOrderDetailServiceImpl.page(page, Wrappers.query(jkyOmsOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jkyomsorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jkyOmsOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jkyOmsOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/jkyomsorderdetails")
  public XfR save(@RequestBody JkyOmsOrderDetail jkyOmsOrderDetail) {
     return XfR.ok(jkyOmsOrderDetailServiceImpl.save(jkyOmsOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jkyOmsOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/jkyomsorderdetails/{id}")
  public XfR putUpdate(@RequestBody JkyOmsOrderDetail jkyOmsOrderDetail,@PathVariable Long id) {
      jkyOmsOrderDetail.setId(id);
      return XfR.ok(jkyOmsOrderDetailServiceImpl.updateById(jkyOmsOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jkyOmsOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jkyomsorderdetails/{id}")
  public XfR patchUpdate(@RequestBody JkyOmsOrderDetail jkyOmsOrderDetail,@PathVariable Long id) {
      JkyOmsOrderDetail upjkyOmsOrderDetail = jkyOmsOrderDetailServiceImpl.getById(id);
      if(upjkyOmsOrderDetail != null){
        upjkyOmsOrderDetail = ObjectCopyUtils.copyProperties(jkyOmsOrderDetail,upjkyOmsOrderDetail,true);
      }
      return XfR.ok(jkyOmsOrderDetailServiceImpl.updateById(upjkyOmsOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jkyomsorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jkyOmsOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/jkyomsorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jky_oms_order_detail");
     params.put("request", condition);

     return XfR.ok(jkyOmsOrderDetailServiceImpl.querys(params));
  }

}
