package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.KsSettlement;
import com.xforceplus.ultraman.app.policymanagement.service.IKsSettlementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 快手结算单前端控制器
 *
 * @author ultraman
 * @date 2024-11-13
 */
@RestController
public class KsSettlementController {

  @Autowired
  private IKsSettlementService ksSettlementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ksSettlement 快手结算单
   * @return
   */
  @GetMapping("/kssettlements" )
  public XfR getKsSettlements(XfPage page, KsSettlement ksSettlement) {
    return XfR.ok(ksSettlementServiceImpl.page(page, Wrappers.query(ksSettlement)));
  }

  /**
   * 通过id查询快手结算单
   * @param  id
   * @return XfR
   */
  @GetMapping("/kssettlements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ksSettlementServiceImpl.getById(id));
  }

  /**
   * 新增快手结算单
   * @param ksSettlement 快手结算单
   * @return XfR
   */
  @PostMapping("/kssettlements")
  public XfR save(@RequestBody KsSettlement ksSettlement) {
     return XfR.ok(ksSettlementServiceImpl.save(ksSettlement));
  }

  /**
   * 修改-传入修改后的全部数据快手结算单
   * @param ksSettlement 快手结算单
   * @return XfR
   */
  @PutMapping("/kssettlements/{id}")
  public XfR putUpdate(@RequestBody KsSettlement ksSettlement,@PathVariable Long id) {
      ksSettlement.setId(id);
      return XfR.ok(ksSettlementServiceImpl.updateById(ksSettlement));
  }

  /**
   * 修改-传入修改的数据快手结算单
   * @param ksSettlement 快手结算单
   * @return XfR
   */
  @PatchMapping("/kssettlements/{id}")
  public XfR patchUpdate(@RequestBody KsSettlement ksSettlement,@PathVariable Long id) {
      KsSettlement upksSettlement = ksSettlementServiceImpl.getById(id);
      if(upksSettlement != null){
        upksSettlement = ObjectCopyUtils.copyProperties(ksSettlement,upksSettlement,true);
      }
      return XfR.ok(ksSettlementServiceImpl.updateById(upksSettlement));
  }

  /**
   * 通过id删除快手结算单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/kssettlements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ksSettlementServiceImpl.removeById(id));
  }

  @PostMapping("/kssettlements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ks_settlement");
     params.put("request", condition);

     return XfR.ok(ksSettlementServiceImpl.querys(params));
  }

}
