package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ExpenseInvoiceSettlementdetail;
import com.xforceplus.ultraman.app.policymanagement.service.IExpenseInvoiceSettlementdetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-20
 */
@RestController
public class ExpenseInvoiceSettlementdetailController {

  @Autowired
  private IExpenseInvoiceSettlementdetailService expenseInvoiceSettlementdetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expenseInvoiceSettlementdetail ${table.comment}
   * @return
   */
  @GetMapping("/expenseinvoicesettlementdetails" )
  public XfR getExpenseInvoiceSettlementdetails(XfPage page, ExpenseInvoiceSettlementdetail expenseInvoiceSettlementdetail) {
    return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.page(page, Wrappers.query(expenseInvoiceSettlementdetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expenseinvoicesettlementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expenseInvoiceSettlementdetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/expenseinvoicesettlementdetails")
  public XfR save(@RequestBody ExpenseInvoiceSettlementdetail expenseInvoiceSettlementdetail) {
     return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.save(expenseInvoiceSettlementdetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expenseInvoiceSettlementdetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/expenseinvoicesettlementdetails/{id}")
  public XfR putUpdate(@RequestBody ExpenseInvoiceSettlementdetail expenseInvoiceSettlementdetail,@PathVariable Long id) {
      expenseInvoiceSettlementdetail.setId(id);
      return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.updateById(expenseInvoiceSettlementdetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expenseInvoiceSettlementdetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expenseinvoicesettlementdetails/{id}")
  public XfR patchUpdate(@RequestBody ExpenseInvoiceSettlementdetail expenseInvoiceSettlementdetail,@PathVariable Long id) {
      ExpenseInvoiceSettlementdetail upexpenseInvoiceSettlementdetail = expenseInvoiceSettlementdetailServiceImpl.getById(id);
      if(upexpenseInvoiceSettlementdetail != null){
        upexpenseInvoiceSettlementdetail = ObjectCopyUtils.copyProperties(expenseInvoiceSettlementdetail,upexpenseInvoiceSettlementdetail,true);
      }
      return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.updateById(upexpenseInvoiceSettlementdetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expenseinvoicesettlementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.removeById(id));
  }

  @PostMapping("/expenseinvoicesettlementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expense_invoice_settlementdetail");
     params.put("request", condition);

     return XfR.ok(expenseInvoiceSettlementdetailServiceImpl.querys(params));
  }

}
