package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SystemExtendDomainField;
import com.xforceplus.ultraman.app.policymanagement.service.ISystemExtendDomainFieldService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 领域扩展字段系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-11-20
 */
@RestController
public class SystemExtendDomainFieldController {

  @Autowired
  private ISystemExtendDomainFieldService systemExtendDomainFieldServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemExtendDomainField 领域扩展字段系统对象
   * @return
   */
  @GetMapping("/systemextenddomainfields" )
  public XfR getSystemExtendDomainFields(XfPage page, SystemExtendDomainField systemExtendDomainField) {
    return XfR.ok(systemExtendDomainFieldServiceImpl.page(page, Wrappers.query(systemExtendDomainField)));
  }

  /**
   * 通过id查询领域扩展字段系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemextenddomainfields/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemExtendDomainFieldServiceImpl.getById(id));
  }

  /**
   * 新增领域扩展字段系统对象
   * @param systemExtendDomainField 领域扩展字段系统对象
   * @return XfR
   */
  @PostMapping("/systemextenddomainfields")
  public XfR save(@RequestBody SystemExtendDomainField systemExtendDomainField) {
     return XfR.ok(systemExtendDomainFieldServiceImpl.save(systemExtendDomainField));
  }

  /**
   * 修改-传入修改后的全部数据领域扩展字段系统对象
   * @param systemExtendDomainField 领域扩展字段系统对象
   * @return XfR
   */
  @PutMapping("/systemextenddomainfields/{id}")
  public XfR putUpdate(@RequestBody SystemExtendDomainField systemExtendDomainField,@PathVariable Long id) {
      systemExtendDomainField.setId(id);
      return XfR.ok(systemExtendDomainFieldServiceImpl.updateById(systemExtendDomainField));
  }

  /**
   * 修改-传入修改的数据领域扩展字段系统对象
   * @param systemExtendDomainField 领域扩展字段系统对象
   * @return XfR
   */
  @PatchMapping("/systemextenddomainfields/{id}")
  public XfR patchUpdate(@RequestBody SystemExtendDomainField systemExtendDomainField,@PathVariable Long id) {
      SystemExtendDomainField upsystemExtendDomainField = systemExtendDomainFieldServiceImpl.getById(id);
      if(upsystemExtendDomainField != null){
        upsystemExtendDomainField = ObjectCopyUtils.copyProperties(systemExtendDomainField,upsystemExtendDomainField,true);
      }
      return XfR.ok(systemExtendDomainFieldServiceImpl.updateById(upsystemExtendDomainField));
  }

  /**
   * 通过id删除领域扩展字段系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemextenddomainfields/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemExtendDomainFieldServiceImpl.removeById(id));
  }

  @PostMapping("/systemextenddomainfields/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_extend_domain_field");
     params.put("request", condition);

     return XfR.ok(systemExtendDomainFieldServiceImpl.querys(params));
  }

}
