package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.WriteOffResultItemReceivableOrder;
import com.xforceplus.ultraman.app.policymanagement.service.IWriteOffResultItemReceivableOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销结果和应收订单关系前端控制器
 *
 * @author ultraman
 * @date 2024-11-20
 */
@RestController
public class WriteOffResultItemReceivableOrderController {

  @Autowired
  private IWriteOffResultItemReceivableOrderService writeOffResultItemReceivableOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultItemReceivableOrder 应收回款核销结果和应收订单关系
   * @return
   */
  @GetMapping("/writeoffresultitemreceivableorders" )
  public XfR getWriteOffResultItemReceivableOrders(XfPage page, WriteOffResultItemReceivableOrder writeOffResultItemReceivableOrder) {
    return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.page(page, Wrappers.query(writeOffResultItemReceivableOrder)));
  }

  /**
   * 通过id查询应收回款核销结果和应收订单关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresultitemreceivableorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销结果和应收订单关系
   * @param writeOffResultItemReceivableOrder 应收回款核销结果和应收订单关系
   * @return XfR
   */
  @PostMapping("/writeoffresultitemreceivableorders")
  public XfR save(@RequestBody WriteOffResultItemReceivableOrder writeOffResultItemReceivableOrder) {
     return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.save(writeOffResultItemReceivableOrder));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销结果和应收订单关系
   * @param writeOffResultItemReceivableOrder 应收回款核销结果和应收订单关系
   * @return XfR
   */
  @PutMapping("/writeoffresultitemreceivableorders/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultItemReceivableOrder writeOffResultItemReceivableOrder,@PathVariable Long id) {
      writeOffResultItemReceivableOrder.setId(id);
      return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.updateById(writeOffResultItemReceivableOrder));
  }

  /**
   * 修改-传入修改的数据应收回款核销结果和应收订单关系
   * @param writeOffResultItemReceivableOrder 应收回款核销结果和应收订单关系
   * @return XfR
   */
  @PatchMapping("/writeoffresultitemreceivableorders/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultItemReceivableOrder writeOffResultItemReceivableOrder,@PathVariable Long id) {
      WriteOffResultItemReceivableOrder upwriteOffResultItemReceivableOrder = writeOffResultItemReceivableOrderServiceImpl.getById(id);
      if(upwriteOffResultItemReceivableOrder != null){
        upwriteOffResultItemReceivableOrder = ObjectCopyUtils.copyProperties(writeOffResultItemReceivableOrder,upwriteOffResultItemReceivableOrder,true);
      }
      return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.updateById(upwriteOffResultItemReceivableOrder));
  }

  /**
   * 通过id删除应收回款核销结果和应收订单关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresultitemreceivableorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresultitemreceivableorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_item_receivable_order");
     params.put("request", condition);

     return XfR.ok(writeOffResultItemReceivableOrderServiceImpl.querys(params));
  }

}
