package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ExpenseInvoiceSettlement;
import com.xforceplus.ultraman.app.policymanagement.service.IExpenseInvoiceSettlementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-06
 */
@RestController
public class ExpenseInvoiceSettlementController {

  @Autowired
  private IExpenseInvoiceSettlementService expenseInvoiceSettlementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expenseInvoiceSettlement ${table.comment}
   * @return
   */
  @GetMapping("/expenseinvoicesettlements" )
  public XfR getExpenseInvoiceSettlements(XfPage page, ExpenseInvoiceSettlement expenseInvoiceSettlement) {
    return XfR.ok(expenseInvoiceSettlementServiceImpl.page(page, Wrappers.query(expenseInvoiceSettlement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/expenseinvoicesettlements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expenseInvoiceSettlementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param expenseInvoiceSettlement ${table.comment}
   * @return XfR
   */
  @PostMapping("/expenseinvoicesettlements")
  public XfR save(@RequestBody ExpenseInvoiceSettlement expenseInvoiceSettlement) {
     return XfR.ok(expenseInvoiceSettlementServiceImpl.save(expenseInvoiceSettlement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param expenseInvoiceSettlement ${table.comment}
   * @return XfR
   */
  @PutMapping("/expenseinvoicesettlements/{id}")
  public XfR putUpdate(@RequestBody ExpenseInvoiceSettlement expenseInvoiceSettlement,@PathVariable Long id) {
      expenseInvoiceSettlement.setId(id);
      return XfR.ok(expenseInvoiceSettlementServiceImpl.updateById(expenseInvoiceSettlement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param expenseInvoiceSettlement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/expenseinvoicesettlements/{id}")
  public XfR patchUpdate(@RequestBody ExpenseInvoiceSettlement expenseInvoiceSettlement,@PathVariable Long id) {
      ExpenseInvoiceSettlement upexpenseInvoiceSettlement = expenseInvoiceSettlementServiceImpl.getById(id);
      if(upexpenseInvoiceSettlement != null){
        upexpenseInvoiceSettlement = ObjectCopyUtils.copyProperties(expenseInvoiceSettlement,upexpenseInvoiceSettlement,true);
      }
      return XfR.ok(expenseInvoiceSettlementServiceImpl.updateById(upexpenseInvoiceSettlement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expenseinvoicesettlements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expenseInvoiceSettlementServiceImpl.removeById(id));
  }

  @PostMapping("/expenseinvoicesettlements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expense_invoice_settlement");
     params.put("request", condition);

     return XfR.ok(expenseInvoiceSettlementServiceImpl.querys(params));
  }

}
