package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableCheckResultItem;
import com.xforceplus.ultraman.app.policymanagement.service.IReceivableCheckResultItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收对账结果关系前端控制器
 *
 * @author ultraman
 * @date 2024-12-06
 */
@RestController
public class ReceivableCheckResultItemController {

  @Autowired
  private IReceivableCheckResultItemService receivableCheckResultItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableCheckResultItem 应收对账结果关系
   * @return
   */
  @GetMapping("/receivablecheckresultitems" )
  public XfR getReceivableCheckResultItems(XfPage page, ReceivableCheckResultItem receivableCheckResultItem) {
    return XfR.ok(receivableCheckResultItemServiceImpl.page(page, Wrappers.query(receivableCheckResultItem)));
  }

  /**
   * 通过id查询应收对账结果关系
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablecheckresultitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableCheckResultItemServiceImpl.getById(id));
  }

  /**
   * 新增应收对账结果关系
   * @param receivableCheckResultItem 应收对账结果关系
   * @return XfR
   */
  @PostMapping("/receivablecheckresultitems")
  public XfR save(@RequestBody ReceivableCheckResultItem receivableCheckResultItem) {
     return XfR.ok(receivableCheckResultItemServiceImpl.save(receivableCheckResultItem));
  }

  /**
   * 修改-传入修改后的全部数据应收对账结果关系
   * @param receivableCheckResultItem 应收对账结果关系
   * @return XfR
   */
  @PutMapping("/receivablecheckresultitems/{id}")
  public XfR putUpdate(@RequestBody ReceivableCheckResultItem receivableCheckResultItem,@PathVariable Long id) {
      receivableCheckResultItem.setId(id);
      return XfR.ok(receivableCheckResultItemServiceImpl.updateById(receivableCheckResultItem));
  }

  /**
   * 修改-传入修改的数据应收对账结果关系
   * @param receivableCheckResultItem 应收对账结果关系
   * @return XfR
   */
  @PatchMapping("/receivablecheckresultitems/{id}")
  public XfR patchUpdate(@RequestBody ReceivableCheckResultItem receivableCheckResultItem,@PathVariable Long id) {
      ReceivableCheckResultItem upreceivableCheckResultItem = receivableCheckResultItemServiceImpl.getById(id);
      if(upreceivableCheckResultItem != null){
        upreceivableCheckResultItem = ObjectCopyUtils.copyProperties(receivableCheckResultItem,upreceivableCheckResultItem,true);
      }
      return XfR.ok(receivableCheckResultItemServiceImpl.updateById(upreceivableCheckResultItem));
  }

  /**
   * 通过id删除应收对账结果关系
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablecheckresultitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableCheckResultItemServiceImpl.removeById(id));
  }

  @PostMapping("/receivablecheckresultitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_check_result_item");
     params.put("request", condition);

     return XfR.ok(receivableCheckResultItemServiceImpl.querys(params));
  }

}
