package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableSalesOrderDetail;
import com.xforceplus.ultraman.app.policymanagement.service.IReceivableSalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-06
 */
@RestController
public class ReceivableSalesOrderDetailController {

  @Autowired
  private IReceivableSalesOrderDetailService receivableSalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableSalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/receivablesalesorderdetails" )
  public XfR getReceivableSalesOrderDetails(XfPage page, ReceivableSalesOrderDetail receivableSalesOrderDetail) {
    return XfR.ok(receivableSalesOrderDetailServiceImpl.page(page, Wrappers.query(receivableSalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablesalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableSalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivableSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivablesalesorderdetails")
  public XfR save(@RequestBody ReceivableSalesOrderDetail receivableSalesOrderDetail) {
     return XfR.ok(receivableSalesOrderDetailServiceImpl.save(receivableSalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivableSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivablesalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody ReceivableSalesOrderDetail receivableSalesOrderDetail,@PathVariable Long id) {
      receivableSalesOrderDetail.setId(id);
      return XfR.ok(receivableSalesOrderDetailServiceImpl.updateById(receivableSalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivableSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivablesalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody ReceivableSalesOrderDetail receivableSalesOrderDetail,@PathVariable Long id) {
      ReceivableSalesOrderDetail upreceivableSalesOrderDetail = receivableSalesOrderDetailServiceImpl.getById(id);
      if(upreceivableSalesOrderDetail != null){
        upreceivableSalesOrderDetail = ObjectCopyUtils.copyProperties(receivableSalesOrderDetail,upreceivableSalesOrderDetail,true);
      }
      return XfR.ok(receivableSalesOrderDetailServiceImpl.updateById(upreceivableSalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablesalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableSalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/receivablesalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(receivableSalesOrderDetailServiceImpl.querys(params));
  }

}
