/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.policymanagement.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.app.policymanagement.entity.Shop;
import com.xforceplus.ultraman.app.policymanagement.service.IShopService;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ShopController {
    @Autowired
    private IShopService shopServiceImpl;

    @GetMapping(value={"/shops"})
    public XfR getShops(XfPage page, Shop shop) {
        return XfR.ok((Object)this.shopServiceImpl.page((IPage)page, (Wrapper)Wrappers.query((Object)shop)));
    }

    @GetMapping(value={"/shops/{id}"})
    public XfR getById(@PathVariable Long id) {
        return XfR.ok((Object)this.shopServiceImpl.getById(id));
    }

    @PostMapping(value={"/shops"})
    public XfR save(@RequestBody Shop shop) {
        return XfR.ok((Object)this.shopServiceImpl.save(shop));
    }

    @PutMapping(value={"/shops/{id}"})
    public XfR putUpdate(@RequestBody Shop shop, @PathVariable Long id) {
        shop.setId(id);
        return XfR.ok((Object)this.shopServiceImpl.updateById(shop));
    }

    @PatchMapping(value={"/shops/{id}"})
    public XfR patchUpdate(@RequestBody Shop shop, @PathVariable Long id) {
        Shop upshop = (Shop)this.shopServiceImpl.getById(id);
        if (upshop != null) {
            upshop = (Shop)ObjectCopyUtils.copyProperties((Object)shop, (Object)upshop, (boolean)true);
        }
        return XfR.ok((Object)this.shopServiceImpl.updateById(upshop));
    }

    @DeleteMapping(value={"/shops/{id}"})
    public XfR removeById(@PathVariable Long id) {
        return XfR.ok((Object)this.shopServiceImpl.removeById(id));
    }

    @PostMapping(value={"/shops/query"})
    public XfR querys(@RequestBody ConditionQueryRequest condition) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tableName", "shop");
        params.put("request", condition);
        return XfR.ok(this.shopServiceImpl.querys(params));
    }
}

