package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.DyAfterSale;
import com.xforceplus.ultraman.app.policymanagement.service.IDyAfterSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class DyAfterSaleController {

  @Autowired
  private IDyAfterSaleService dyAfterSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dyAfterSale ${table.comment}
   * @return
   */
  @GetMapping("/dyaftersales" )
  public XfR getDyAfterSales(XfPage page, DyAfterSale dyAfterSale) {
    return XfR.ok(dyAfterSaleServiceImpl.page(page, Wrappers.query(dyAfterSale)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dyaftersales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dyAfterSaleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dyAfterSale ${table.comment}
   * @return XfR
   */
  @PostMapping("/dyaftersales")
  public XfR save(@RequestBody DyAfterSale dyAfterSale) {
     return XfR.ok(dyAfterSaleServiceImpl.save(dyAfterSale));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dyAfterSale ${table.comment}
   * @return XfR
   */
  @PutMapping("/dyaftersales/{id}")
  public XfR putUpdate(@RequestBody DyAfterSale dyAfterSale,@PathVariable Long id) {
      dyAfterSale.setId(id);
      return XfR.ok(dyAfterSaleServiceImpl.updateById(dyAfterSale));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dyAfterSale ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dyaftersales/{id}")
  public XfR patchUpdate(@RequestBody DyAfterSale dyAfterSale,@PathVariable Long id) {
      DyAfterSale updyAfterSale = dyAfterSaleServiceImpl.getById(id);
      if(updyAfterSale != null){
        updyAfterSale = ObjectCopyUtils.copyProperties(dyAfterSale,updyAfterSale,true);
      }
      return XfR.ok(dyAfterSaleServiceImpl.updateById(updyAfterSale));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dyaftersales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dyAfterSaleServiceImpl.removeById(id));
  }

  @PostMapping("/dyaftersales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dy_after_sale");
     params.put("request", condition);

     return XfR.ok(dyAfterSaleServiceImpl.querys(params));
  }

}
