package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.JdAfterSale;
import com.xforceplus.ultraman.app.policymanagement.service.IJdAfterSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class JdAfterSaleController {

  @Autowired
  private IJdAfterSaleService jdAfterSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jdAfterSale ${table.comment}
   * @return
   */
  @GetMapping("/jdaftersales" )
  public XfR getJdAfterSales(XfPage page, JdAfterSale jdAfterSale) {
    return XfR.ok(jdAfterSaleServiceImpl.page(page, Wrappers.query(jdAfterSale)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jdaftersales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jdAfterSaleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jdAfterSale ${table.comment}
   * @return XfR
   */
  @PostMapping("/jdaftersales")
  public XfR save(@RequestBody JdAfterSale jdAfterSale) {
     return XfR.ok(jdAfterSaleServiceImpl.save(jdAfterSale));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jdAfterSale ${table.comment}
   * @return XfR
   */
  @PutMapping("/jdaftersales/{id}")
  public XfR putUpdate(@RequestBody JdAfterSale jdAfterSale,@PathVariable Long id) {
      jdAfterSale.setId(id);
      return XfR.ok(jdAfterSaleServiceImpl.updateById(jdAfterSale));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jdAfterSale ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jdaftersales/{id}")
  public XfR patchUpdate(@RequestBody JdAfterSale jdAfterSale,@PathVariable Long id) {
      JdAfterSale upjdAfterSale = jdAfterSaleServiceImpl.getById(id);
      if(upjdAfterSale != null){
        upjdAfterSale = ObjectCopyUtils.copyProperties(jdAfterSale,upjdAfterSale,true);
      }
      return XfR.ok(jdAfterSaleServiceImpl.updateById(upjdAfterSale));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jdaftersales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jdAfterSaleServiceImpl.removeById(id));
  }

  @PostMapping("/jdaftersales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jd_after_sale");
     params.put("request", condition);

     return XfR.ok(jdAfterSaleServiceImpl.querys(params));
  }

}
