package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.JdCheck;
import com.xforceplus.ultraman.app.policymanagement.service.IJdCheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 京东账单前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class JdCheckController {

  @Autowired
  private IJdCheckService jdCheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jdCheck 京东账单
   * @return
   */
  @GetMapping("/jdchecks" )
  public XfR getJdChecks(XfPage page, JdCheck jdCheck) {
    return XfR.ok(jdCheckServiceImpl.page(page, Wrappers.query(jdCheck)));
  }

  /**
   * 通过id查询京东账单
   * @param  id
   * @return XfR
   */
  @GetMapping("/jdchecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jdCheckServiceImpl.getById(id));
  }

  /**
   * 新增京东账单
   * @param jdCheck 京东账单
   * @return XfR
   */
  @PostMapping("/jdchecks")
  public XfR save(@RequestBody JdCheck jdCheck) {
     return XfR.ok(jdCheckServiceImpl.save(jdCheck));
  }

  /**
   * 修改-传入修改后的全部数据京东账单
   * @param jdCheck 京东账单
   * @return XfR
   */
  @PutMapping("/jdchecks/{id}")
  public XfR putUpdate(@RequestBody JdCheck jdCheck,@PathVariable Long id) {
      jdCheck.setId(id);
      return XfR.ok(jdCheckServiceImpl.updateById(jdCheck));
  }

  /**
   * 修改-传入修改的数据京东账单
   * @param jdCheck 京东账单
   * @return XfR
   */
  @PatchMapping("/jdchecks/{id}")
  public XfR patchUpdate(@RequestBody JdCheck jdCheck,@PathVariable Long id) {
      JdCheck upjdCheck = jdCheckServiceImpl.getById(id);
      if(upjdCheck != null){
        upjdCheck = ObjectCopyUtils.copyProperties(jdCheck,upjdCheck,true);
      }
      return XfR.ok(jdCheckServiceImpl.updateById(upjdCheck));
  }

  /**
   * 通过id删除京东账单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jdchecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jdCheckServiceImpl.removeById(id));
  }

  @PostMapping("/jdchecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jd_check");
     params.put("request", condition);

     return XfR.ok(jdCheckServiceImpl.querys(params));
  }

}
