package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SalesOrderCheckResultHistory;
import com.xforceplus.ultraman.app.policymanagement.service.ISalesOrderCheckResultHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销售订单对账履历前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class SalesOrderCheckResultHistoryController {

  @Autowired
  private ISalesOrderCheckResultHistoryService salesOrderCheckResultHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesOrderCheckResultHistory 销售订单对账履历
   * @return
   */
  @GetMapping("/salesordercheckresulthistorys" )
  public XfR getSalesOrderCheckResultHistorys(XfPage page, SalesOrderCheckResultHistory salesOrderCheckResultHistory) {
    return XfR.ok(salesOrderCheckResultHistoryServiceImpl.page(page, Wrappers.query(salesOrderCheckResultHistory)));
  }

  /**
   * 通过id查询销售订单对账履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesordercheckresulthistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesOrderCheckResultHistoryServiceImpl.getById(id));
  }

  /**
   * 新增销售订单对账履历
   * @param salesOrderCheckResultHistory 销售订单对账履历
   * @return XfR
   */
  @PostMapping("/salesordercheckresulthistorys")
  public XfR save(@RequestBody SalesOrderCheckResultHistory salesOrderCheckResultHistory) {
     return XfR.ok(salesOrderCheckResultHistoryServiceImpl.save(salesOrderCheckResultHistory));
  }

  /**
   * 修改-传入修改后的全部数据销售订单对账履历
   * @param salesOrderCheckResultHistory 销售订单对账履历
   * @return XfR
   */
  @PutMapping("/salesordercheckresulthistorys/{id}")
  public XfR putUpdate(@RequestBody SalesOrderCheckResultHistory salesOrderCheckResultHistory,@PathVariable Long id) {
      salesOrderCheckResultHistory.setId(id);
      return XfR.ok(salesOrderCheckResultHistoryServiceImpl.updateById(salesOrderCheckResultHistory));
  }

  /**
   * 修改-传入修改的数据销售订单对账履历
   * @param salesOrderCheckResultHistory 销售订单对账履历
   * @return XfR
   */
  @PatchMapping("/salesordercheckresulthistorys/{id}")
  public XfR patchUpdate(@RequestBody SalesOrderCheckResultHistory salesOrderCheckResultHistory,@PathVariable Long id) {
      SalesOrderCheckResultHistory upsalesOrderCheckResultHistory = salesOrderCheckResultHistoryServiceImpl.getById(id);
      if(upsalesOrderCheckResultHistory != null){
        upsalesOrderCheckResultHistory = ObjectCopyUtils.copyProperties(salesOrderCheckResultHistory,upsalesOrderCheckResultHistory,true);
      }
      return XfR.ok(salesOrderCheckResultHistoryServiceImpl.updateById(upsalesOrderCheckResultHistory));
  }

  /**
   * 通过id删除销售订单对账履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesordercheckresulthistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesOrderCheckResultHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/salesordercheckresulthistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_order_check_result_history");
     params.put("request", condition);

     return XfR.ok(salesOrderCheckResultHistoryServiceImpl.querys(params));
  }

}
