package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.Shop;
import com.xforceplus.ultraman.app.policymanagement.service.IShopService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * -作废前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class ShopController {

  @Autowired
  private IShopService shopServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param shop -作废
   * @return
   */
  @GetMapping("/shops" )
  public XfR getShops(XfPage page, Shop shop) {
    return XfR.ok(shopServiceImpl.page(page, Wrappers.query(shop)));
  }

  /**
   * 通过id查询-作废
   * @param  id
   * @return XfR
   */
  @GetMapping("/shops/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(shopServiceImpl.getById(id));
  }

  /**
   * 新增-作废
   * @param shop -作废
   * @return XfR
   */
  @PostMapping("/shops")
  public XfR save(@RequestBody Shop shop) {
     return XfR.ok(shopServiceImpl.save(shop));
  }

  /**
   * 修改-传入修改后的全部数据-作废
   * @param shop -作废
   * @return XfR
   */
  @PutMapping("/shops/{id}")
  public XfR putUpdate(@RequestBody Shop shop,@PathVariable Long id) {
      shop.setId(id);
      return XfR.ok(shopServiceImpl.updateById(shop));
  }

  /**
   * 修改-传入修改的数据-作废
   * @param shop -作废
   * @return XfR
   */
  @PatchMapping("/shops/{id}")
  public XfR patchUpdate(@RequestBody Shop shop,@PathVariable Long id) {
      Shop upshop = shopServiceImpl.getById(id);
      if(upshop != null){
        upshop = ObjectCopyUtils.copyProperties(shop,upshop,true);
      }
      return XfR.ok(shopServiceImpl.updateById(upshop));
  }

  /**
   * 通过id删除-作废
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/shops/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(shopServiceImpl.removeById(id));
  }

  @PostMapping("/shops/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "shop");
     params.put("request", condition);

     return XfR.ok(shopServiceImpl.querys(params));
  }

}
