package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.WriteOffResultItemBillSnapshot;
import com.xforceplus.ultraman.app.policymanagement.service.IWriteOffResultItemBillSnapshotService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销结果和账单关系快照前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class WriteOffResultItemBillSnapshotController {

  @Autowired
  private IWriteOffResultItemBillSnapshotService writeOffResultItemBillSnapshotServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultItemBillSnapshot 应收回款核销结果和账单关系快照
   * @return
   */
  @GetMapping("/writeoffresultitembillsnapshots" )
  public XfR getWriteOffResultItemBillSnapshots(XfPage page, WriteOffResultItemBillSnapshot writeOffResultItemBillSnapshot) {
    return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.page(page, Wrappers.query(writeOffResultItemBillSnapshot)));
  }

  /**
   * 通过id查询应收回款核销结果和账单关系快照
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresultitembillsnapshots/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销结果和账单关系快照
   * @param writeOffResultItemBillSnapshot 应收回款核销结果和账单关系快照
   * @return XfR
   */
  @PostMapping("/writeoffresultitembillsnapshots")
  public XfR save(@RequestBody WriteOffResultItemBillSnapshot writeOffResultItemBillSnapshot) {
     return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.save(writeOffResultItemBillSnapshot));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销结果和账单关系快照
   * @param writeOffResultItemBillSnapshot 应收回款核销结果和账单关系快照
   * @return XfR
   */
  @PutMapping("/writeoffresultitembillsnapshots/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultItemBillSnapshot writeOffResultItemBillSnapshot,@PathVariable Long id) {
      writeOffResultItemBillSnapshot.setId(id);
      return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.updateById(writeOffResultItemBillSnapshot));
  }

  /**
   * 修改-传入修改的数据应收回款核销结果和账单关系快照
   * @param writeOffResultItemBillSnapshot 应收回款核销结果和账单关系快照
   * @return XfR
   */
  @PatchMapping("/writeoffresultitembillsnapshots/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultItemBillSnapshot writeOffResultItemBillSnapshot,@PathVariable Long id) {
      WriteOffResultItemBillSnapshot upwriteOffResultItemBillSnapshot = writeOffResultItemBillSnapshotServiceImpl.getById(id);
      if(upwriteOffResultItemBillSnapshot != null){
        upwriteOffResultItemBillSnapshot = ObjectCopyUtils.copyProperties(writeOffResultItemBillSnapshot,upwriteOffResultItemBillSnapshot,true);
      }
      return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.updateById(upwriteOffResultItemBillSnapshot));
  }

  /**
   * 通过id删除应收回款核销结果和账单关系快照
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresultitembillsnapshots/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresultitembillsnapshots/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_item_bill_snapshot");
     params.put("request", condition);

     return XfR.ok(writeOffResultItemBillSnapshotServiceImpl.querys(params));
  }

}
