package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.WriteOffResultSnapshot;
import com.xforceplus.ultraman.app.policymanagement.service.IWriteOffResultSnapshotService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销结果快照前端控制器
 *
 * @author ultraman
 * @date 2025-01-07
 */
@RestController
public class WriteOffResultSnapshotController {

  @Autowired
  private IWriteOffResultSnapshotService writeOffResultSnapshotServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultSnapshot 应收回款核销结果快照
   * @return
   */
  @GetMapping("/writeoffresultsnapshots" )
  public XfR getWriteOffResultSnapshots(XfPage page, WriteOffResultSnapshot writeOffResultSnapshot) {
    return XfR.ok(writeOffResultSnapshotServiceImpl.page(page, Wrappers.query(writeOffResultSnapshot)));
  }

  /**
   * 通过id查询应收回款核销结果快照
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresultsnapshots/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultSnapshotServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销结果快照
   * @param writeOffResultSnapshot 应收回款核销结果快照
   * @return XfR
   */
  @PostMapping("/writeoffresultsnapshots")
  public XfR save(@RequestBody WriteOffResultSnapshot writeOffResultSnapshot) {
     return XfR.ok(writeOffResultSnapshotServiceImpl.save(writeOffResultSnapshot));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销结果快照
   * @param writeOffResultSnapshot 应收回款核销结果快照
   * @return XfR
   */
  @PutMapping("/writeoffresultsnapshots/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultSnapshot writeOffResultSnapshot,@PathVariable Long id) {
      writeOffResultSnapshot.setId(id);
      return XfR.ok(writeOffResultSnapshotServiceImpl.updateById(writeOffResultSnapshot));
  }

  /**
   * 修改-传入修改的数据应收回款核销结果快照
   * @param writeOffResultSnapshot 应收回款核销结果快照
   * @return XfR
   */
  @PatchMapping("/writeoffresultsnapshots/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultSnapshot writeOffResultSnapshot,@PathVariable Long id) {
      WriteOffResultSnapshot upwriteOffResultSnapshot = writeOffResultSnapshotServiceImpl.getById(id);
      if(upwriteOffResultSnapshot != null){
        upwriteOffResultSnapshot = ObjectCopyUtils.copyProperties(writeOffResultSnapshot,upwriteOffResultSnapshot,true);
      }
      return XfR.ok(writeOffResultSnapshotServiceImpl.updateById(upwriteOffResultSnapshot));
  }

  /**
   * 通过id删除应收回款核销结果快照
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresultsnapshots/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultSnapshotServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresultsnapshots/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_snapshot");
     params.put("request", condition);

     return XfR.ok(writeOffResultSnapshotServiceImpl.querys(params));
  }

}
