package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.AfterSalesOrderCheckResult;
import com.xforceplus.ultraman.app.policymanagement.service.IAfterSalesOrderCheckResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 售后单对账结果前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class AfterSalesOrderCheckResultController {

  @Autowired
  private IAfterSalesOrderCheckResultService afterSalesOrderCheckResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param afterSalesOrderCheckResult 售后单对账结果
   * @return
   */
  @GetMapping("/aftersalesordercheckresults" )
  public XfR getAfterSalesOrderCheckResults(XfPage page, AfterSalesOrderCheckResult afterSalesOrderCheckResult) {
    return XfR.ok(afterSalesOrderCheckResultServiceImpl.page(page, Wrappers.query(afterSalesOrderCheckResult)));
  }

  /**
   * 通过id查询售后单对账结果
   * @param  id
   * @return XfR
   */
  @GetMapping("/aftersalesordercheckresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultServiceImpl.getById(id));
  }

  /**
   * 新增售后单对账结果
   * @param afterSalesOrderCheckResult 售后单对账结果
   * @return XfR
   */
  @PostMapping("/aftersalesordercheckresults")
  public XfR save(@RequestBody AfterSalesOrderCheckResult afterSalesOrderCheckResult) {
     return XfR.ok(afterSalesOrderCheckResultServiceImpl.save(afterSalesOrderCheckResult));
  }

  /**
   * 修改-传入修改后的全部数据售后单对账结果
   * @param afterSalesOrderCheckResult 售后单对账结果
   * @return XfR
   */
  @PutMapping("/aftersalesordercheckresults/{id}")
  public XfR putUpdate(@RequestBody AfterSalesOrderCheckResult afterSalesOrderCheckResult,@PathVariable Long id) {
      afterSalesOrderCheckResult.setId(id);
      return XfR.ok(afterSalesOrderCheckResultServiceImpl.updateById(afterSalesOrderCheckResult));
  }

  /**
   * 修改-传入修改的数据售后单对账结果
   * @param afterSalesOrderCheckResult 售后单对账结果
   * @return XfR
   */
  @PatchMapping("/aftersalesordercheckresults/{id}")
  public XfR patchUpdate(@RequestBody AfterSalesOrderCheckResult afterSalesOrderCheckResult,@PathVariable Long id) {
      AfterSalesOrderCheckResult upafterSalesOrderCheckResult = afterSalesOrderCheckResultServiceImpl.getById(id);
      if(upafterSalesOrderCheckResult != null){
        upafterSalesOrderCheckResult = ObjectCopyUtils.copyProperties(afterSalesOrderCheckResult,upafterSalesOrderCheckResult,true);
      }
      return XfR.ok(afterSalesOrderCheckResultServiceImpl.updateById(upafterSalesOrderCheckResult));
  }

  /**
   * 通过id删除售后单对账结果
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aftersalesordercheckresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(afterSalesOrderCheckResultServiceImpl.removeById(id));
  }

  @PostMapping("/aftersalesordercheckresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "after_sales_order_check_result");
     params.put("request", condition);

     return XfR.ok(afterSalesOrderCheckResultServiceImpl.querys(params));
  }

}
