package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.CollectionOrder;
import com.xforceplus.ultraman.app.policymanagement.service.ICollectionOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class CollectionOrderController {

  @Autowired
  private ICollectionOrderService collectionOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param collectionOrder ${table.comment}
   * @return
   */
  @GetMapping("/collectionorders" )
  public XfR getCollectionOrders(XfPage page, CollectionOrder collectionOrder) {
    return XfR.ok(collectionOrderServiceImpl.page(page, Wrappers.query(collectionOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/collectionorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(collectionOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param collectionOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/collectionorders")
  public XfR save(@RequestBody CollectionOrder collectionOrder) {
     return XfR.ok(collectionOrderServiceImpl.save(collectionOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param collectionOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/collectionorders/{id}")
  public XfR putUpdate(@RequestBody CollectionOrder collectionOrder,@PathVariable Long id) {
      collectionOrder.setId(id);
      return XfR.ok(collectionOrderServiceImpl.updateById(collectionOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param collectionOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/collectionorders/{id}")
  public XfR patchUpdate(@RequestBody CollectionOrder collectionOrder,@PathVariable Long id) {
      CollectionOrder upcollectionOrder = collectionOrderServiceImpl.getById(id);
      if(upcollectionOrder != null){
        upcollectionOrder = ObjectCopyUtils.copyProperties(collectionOrder,upcollectionOrder,true);
      }
      return XfR.ok(collectionOrderServiceImpl.updateById(upcollectionOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/collectionorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(collectionOrderServiceImpl.removeById(id));
  }

  @PostMapping("/collectionorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "collection_order");
     params.put("request", condition);

     return XfR.ok(collectionOrderServiceImpl.querys(params));
  }

}
