package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.DyAfterSaleDetail;
import com.xforceplus.ultraman.app.policymanagement.service.IDyAfterSaleDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class DyAfterSaleDetailController {

  @Autowired
  private IDyAfterSaleDetailService dyAfterSaleDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dyAfterSaleDetail ${table.comment}
   * @return
   */
  @GetMapping("/dyaftersaledetails" )
  public XfR getDyAfterSaleDetails(XfPage page, DyAfterSaleDetail dyAfterSaleDetail) {
    return XfR.ok(dyAfterSaleDetailServiceImpl.page(page, Wrappers.query(dyAfterSaleDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dyaftersaledetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dyAfterSaleDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dyAfterSaleDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/dyaftersaledetails")
  public XfR save(@RequestBody DyAfterSaleDetail dyAfterSaleDetail) {
     return XfR.ok(dyAfterSaleDetailServiceImpl.save(dyAfterSaleDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dyAfterSaleDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/dyaftersaledetails/{id}")
  public XfR putUpdate(@RequestBody DyAfterSaleDetail dyAfterSaleDetail,@PathVariable Long id) {
      dyAfterSaleDetail.setId(id);
      return XfR.ok(dyAfterSaleDetailServiceImpl.updateById(dyAfterSaleDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dyAfterSaleDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dyaftersaledetails/{id}")
  public XfR patchUpdate(@RequestBody DyAfterSaleDetail dyAfterSaleDetail,@PathVariable Long id) {
      DyAfterSaleDetail updyAfterSaleDetail = dyAfterSaleDetailServiceImpl.getById(id);
      if(updyAfterSaleDetail != null){
        updyAfterSaleDetail = ObjectCopyUtils.copyProperties(dyAfterSaleDetail,updyAfterSaleDetail,true);
      }
      return XfR.ok(dyAfterSaleDetailServiceImpl.updateById(updyAfterSaleDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dyaftersaledetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dyAfterSaleDetailServiceImpl.removeById(id));
  }

  @PostMapping("/dyaftersaledetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dy_after_sale_detail");
     params.put("request", condition);

     return XfR.ok(dyAfterSaleDetailServiceImpl.querys(params));
  }

}
