package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.KsAfterSale;
import com.xforceplus.ultraman.app.policymanagement.service.IKsAfterSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class KsAfterSaleController {

  @Autowired
  private IKsAfterSaleService ksAfterSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ksAfterSale ${table.comment}
   * @return
   */
  @GetMapping("/ksaftersales" )
  public XfR getKsAfterSales(XfPage page, KsAfterSale ksAfterSale) {
    return XfR.ok(ksAfterSaleServiceImpl.page(page, Wrappers.query(ksAfterSale)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ksaftersales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ksAfterSaleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ksAfterSale ${table.comment}
   * @return XfR
   */
  @PostMapping("/ksaftersales")
  public XfR save(@RequestBody KsAfterSale ksAfterSale) {
     return XfR.ok(ksAfterSaleServiceImpl.save(ksAfterSale));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ksAfterSale ${table.comment}
   * @return XfR
   */
  @PutMapping("/ksaftersales/{id}")
  public XfR putUpdate(@RequestBody KsAfterSale ksAfterSale,@PathVariable Long id) {
      ksAfterSale.setId(id);
      return XfR.ok(ksAfterSaleServiceImpl.updateById(ksAfterSale));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ksAfterSale ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ksaftersales/{id}")
  public XfR patchUpdate(@RequestBody KsAfterSale ksAfterSale,@PathVariable Long id) {
      KsAfterSale upksAfterSale = ksAfterSaleServiceImpl.getById(id);
      if(upksAfterSale != null){
        upksAfterSale = ObjectCopyUtils.copyProperties(ksAfterSale,upksAfterSale,true);
      }
      return XfR.ok(ksAfterSaleServiceImpl.updateById(upksAfterSale));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ksaftersales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ksAfterSaleServiceImpl.removeById(id));
  }

  @PostMapping("/ksaftersales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ks_after_sale");
     params.put("request", condition);

     return XfR.ok(ksAfterSaleServiceImpl.querys(params));
  }

}
