package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.OmsAfterSaleDetail;
import com.xforceplus.ultraman.app.policymanagement.service.IOmsAfterSaleDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 网店管家OMS售后明细前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class OmsAfterSaleDetailController {

  @Autowired
  private IOmsAfterSaleDetailService omsAfterSaleDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omsAfterSaleDetail 网店管家OMS售后明细
   * @return
   */
  @GetMapping("/omsaftersaledetails" )
  public XfR getOmsAfterSaleDetails(XfPage page, OmsAfterSaleDetail omsAfterSaleDetail) {
    return XfR.ok(omsAfterSaleDetailServiceImpl.page(page, Wrappers.query(omsAfterSaleDetail)));
  }

  /**
   * 通过id查询网店管家OMS售后明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/omsaftersaledetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omsAfterSaleDetailServiceImpl.getById(id));
  }

  /**
   * 新增网店管家OMS售后明细
   * @param omsAfterSaleDetail 网店管家OMS售后明细
   * @return XfR
   */
  @PostMapping("/omsaftersaledetails")
  public XfR save(@RequestBody OmsAfterSaleDetail omsAfterSaleDetail) {
     return XfR.ok(omsAfterSaleDetailServiceImpl.save(omsAfterSaleDetail));
  }

  /**
   * 修改-传入修改后的全部数据网店管家OMS售后明细
   * @param omsAfterSaleDetail 网店管家OMS售后明细
   * @return XfR
   */
  @PutMapping("/omsaftersaledetails/{id}")
  public XfR putUpdate(@RequestBody OmsAfterSaleDetail omsAfterSaleDetail,@PathVariable Long id) {
      omsAfterSaleDetail.setId(id);
      return XfR.ok(omsAfterSaleDetailServiceImpl.updateById(omsAfterSaleDetail));
  }

  /**
   * 修改-传入修改的数据网店管家OMS售后明细
   * @param omsAfterSaleDetail 网店管家OMS售后明细
   * @return XfR
   */
  @PatchMapping("/omsaftersaledetails/{id}")
  public XfR patchUpdate(@RequestBody OmsAfterSaleDetail omsAfterSaleDetail,@PathVariable Long id) {
      OmsAfterSaleDetail upomsAfterSaleDetail = omsAfterSaleDetailServiceImpl.getById(id);
      if(upomsAfterSaleDetail != null){
        upomsAfterSaleDetail = ObjectCopyUtils.copyProperties(omsAfterSaleDetail,upomsAfterSaleDetail,true);
      }
      return XfR.ok(omsAfterSaleDetailServiceImpl.updateById(upomsAfterSaleDetail));
  }

  /**
   * 通过id删除网店管家OMS售后明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/omsaftersaledetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omsAfterSaleDetailServiceImpl.removeById(id));
  }

  @PostMapping("/omsaftersaledetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oms_after_sale_detail");
     params.put("request", condition);

     return XfR.ok(omsAfterSaleDetailServiceImpl.querys(params));
  }

}
