package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableCheckResult;
import com.xforceplus.ultraman.app.policymanagement.service.IReceivableCheckResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收对账结果前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class ReceivableCheckResultController {

  @Autowired
  private IReceivableCheckResultService receivableCheckResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableCheckResult 应收对账结果
   * @return
   */
  @GetMapping("/receivablecheckresults" )
  public XfR getReceivableCheckResults(XfPage page, ReceivableCheckResult receivableCheckResult) {
    return XfR.ok(receivableCheckResultServiceImpl.page(page, Wrappers.query(receivableCheckResult)));
  }

  /**
   * 通过id查询应收对账结果
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablecheckresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableCheckResultServiceImpl.getById(id));
  }

  /**
   * 新增应收对账结果
   * @param receivableCheckResult 应收对账结果
   * @return XfR
   */
  @PostMapping("/receivablecheckresults")
  public XfR save(@RequestBody ReceivableCheckResult receivableCheckResult) {
     return XfR.ok(receivableCheckResultServiceImpl.save(receivableCheckResult));
  }

  /**
   * 修改-传入修改后的全部数据应收对账结果
   * @param receivableCheckResult 应收对账结果
   * @return XfR
   */
  @PutMapping("/receivablecheckresults/{id}")
  public XfR putUpdate(@RequestBody ReceivableCheckResult receivableCheckResult,@PathVariable Long id) {
      receivableCheckResult.setId(id);
      return XfR.ok(receivableCheckResultServiceImpl.updateById(receivableCheckResult));
  }

  /**
   * 修改-传入修改的数据应收对账结果
   * @param receivableCheckResult 应收对账结果
   * @return XfR
   */
  @PatchMapping("/receivablecheckresults/{id}")
  public XfR patchUpdate(@RequestBody ReceivableCheckResult receivableCheckResult,@PathVariable Long id) {
      ReceivableCheckResult upreceivableCheckResult = receivableCheckResultServiceImpl.getById(id);
      if(upreceivableCheckResult != null){
        upreceivableCheckResult = ObjectCopyUtils.copyProperties(receivableCheckResult,upreceivableCheckResult,true);
      }
      return XfR.ok(receivableCheckResultServiceImpl.updateById(upreceivableCheckResult));
  }

  /**
   * 通过id删除应收对账结果
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablecheckresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableCheckResultServiceImpl.removeById(id));
  }

  @PostMapping("/receivablecheckresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_check_result");
     params.put("request", condition);

     return XfR.ok(receivableCheckResultServiceImpl.querys(params));
  }

}
