package com.xforceplus.ultraman.app.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableCheckResultHistory;
import com.xforceplus.ultraman.app.policymanagement.service.IReceivableCheckResultHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收对账履历前端控制器
 *
 * @author ultraman
 * @date 2025-01-13
 */
@RestController
public class ReceivableCheckResultHistoryController {

  @Autowired
  private IReceivableCheckResultHistoryService receivableCheckResultHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableCheckResultHistory 应收对账履历
   * @return
   */
  @GetMapping("/receivablecheckresulthistorys" )
  public XfR getReceivableCheckResultHistorys(XfPage page, ReceivableCheckResultHistory receivableCheckResultHistory) {
    return XfR.ok(receivableCheckResultHistoryServiceImpl.page(page, Wrappers.query(receivableCheckResultHistory)));
  }

  /**
   * 通过id查询应收对账履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablecheckresulthistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableCheckResultHistoryServiceImpl.getById(id));
  }

  /**
   * 新增应收对账履历
   * @param receivableCheckResultHistory 应收对账履历
   * @return XfR
   */
  @PostMapping("/receivablecheckresulthistorys")
  public XfR save(@RequestBody ReceivableCheckResultHistory receivableCheckResultHistory) {
     return XfR.ok(receivableCheckResultHistoryServiceImpl.save(receivableCheckResultHistory));
  }

  /**
   * 修改-传入修改后的全部数据应收对账履历
   * @param receivableCheckResultHistory 应收对账履历
   * @return XfR
   */
  @PutMapping("/receivablecheckresulthistorys/{id}")
  public XfR putUpdate(@RequestBody ReceivableCheckResultHistory receivableCheckResultHistory,@PathVariable Long id) {
      receivableCheckResultHistory.setId(id);
      return XfR.ok(receivableCheckResultHistoryServiceImpl.updateById(receivableCheckResultHistory));
  }

  /**
   * 修改-传入修改的数据应收对账履历
   * @param receivableCheckResultHistory 应收对账履历
   * @return XfR
   */
  @PatchMapping("/receivablecheckresulthistorys/{id}")
  public XfR patchUpdate(@RequestBody ReceivableCheckResultHistory receivableCheckResultHistory,@PathVariable Long id) {
      ReceivableCheckResultHistory upreceivableCheckResultHistory = receivableCheckResultHistoryServiceImpl.getById(id);
      if(upreceivableCheckResultHistory != null){
        upreceivableCheckResultHistory = ObjectCopyUtils.copyProperties(receivableCheckResultHistory,upreceivableCheckResultHistory,true);
      }
      return XfR.ok(receivableCheckResultHistoryServiceImpl.updateById(upreceivableCheckResultHistory));
  }

  /**
   * 通过id删除应收对账履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablecheckresulthistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableCheckResultHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/receivablecheckresulthistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_check_result_history");
     params.put("request", condition);

     return XfR.ok(receivableCheckResultHistoryServiceImpl.querys(params));
  }

}
