package com.xforceplus.ultraman.app.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.polyfileco.entity.FileTemplateDetail;
import com.xforceplus.ultraman.app.polyfileco.service.IFileTemplateDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 文件模版明细前端控制器
 *
 * @author ultraman
 * @date 2024-11-11
 */
@RestController
public class FileTemplateDetailController {

  @Autowired
  private IFileTemplateDetailService fileTemplateDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fileTemplateDetail 文件模版明细
   * @return
   */
  @GetMapping("/filetemplatedetails" )
  public XfR getFileTemplateDetails(XfPage page, FileTemplateDetail fileTemplateDetail) {
    return XfR.ok(fileTemplateDetailServiceImpl.page(page, Wrappers.query(fileTemplateDetail)));
  }

  /**
   * 通过id查询文件模版明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/filetemplatedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fileTemplateDetailServiceImpl.getById(id));
  }

  /**
   * 新增文件模版明细
   * @param fileTemplateDetail 文件模版明细
   * @return XfR
   */
  @PostMapping("/filetemplatedetails")
  public XfR save(@RequestBody FileTemplateDetail fileTemplateDetail) {
     return XfR.ok(fileTemplateDetailServiceImpl.save(fileTemplateDetail));
  }

  /**
   * 修改-传入修改后的全部数据文件模版明细
   * @param fileTemplateDetail 文件模版明细
   * @return XfR
   */
  @PutMapping("/filetemplatedetails/{id}")
  public XfR putUpdate(@RequestBody FileTemplateDetail fileTemplateDetail,@PathVariable Long id) {
      fileTemplateDetail.setId(id);
      return XfR.ok(fileTemplateDetailServiceImpl.updateById(fileTemplateDetail));
  }

  /**
   * 修改-传入修改的数据文件模版明细
   * @param fileTemplateDetail 文件模版明细
   * @return XfR
   */
  @PatchMapping("/filetemplatedetails/{id}")
  public XfR patchUpdate(@RequestBody FileTemplateDetail fileTemplateDetail,@PathVariable Long id) {
      FileTemplateDetail upfileTemplateDetail = fileTemplateDetailServiceImpl.getById(id);
      if(upfileTemplateDetail != null){
        upfileTemplateDetail = ObjectCopyUtils.copyProperties(fileTemplateDetail,upfileTemplateDetail,true);
      }
      return XfR.ok(fileTemplateDetailServiceImpl.updateById(upfileTemplateDetail));
  }

  /**
   * 通过id删除文件模版明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/filetemplatedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fileTemplateDetailServiceImpl.removeById(id));
  }

  @PostMapping("/filetemplatedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "file_template_detail");
     params.put("request", condition);

     return XfR.ok(fileTemplateDetailServiceImpl.querys(params));
  }

}
