package com.xforceplus.ultraman.app.polyfileco.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.polyfileco.entity.PayApplicationDetails;
import com.xforceplus.ultraman.app.polyfileco.service.IPayApplicationDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 付款申请单明细前端控制器
 *
 * @author ultraman
 * @date 2024-11-11
 */
@RestController
public class PayApplicationDetailsController {

  @Autowired
  private IPayApplicationDetailsService payApplicationDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payApplicationDetails 付款申请单明细
   * @return
   */
  @GetMapping("/payapplicationdetailss" )
  public XfR getPayApplicationDetailss(XfPage page, PayApplicationDetails payApplicationDetails) {
    return XfR.ok(payApplicationDetailsServiceImpl.page(page, Wrappers.query(payApplicationDetails)));
  }

  /**
   * 通过id查询付款申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/payapplicationdetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payApplicationDetailsServiceImpl.getById(id));
  }

  /**
   * 新增付款申请单明细
   * @param payApplicationDetails 付款申请单明细
   * @return XfR
   */
  @PostMapping("/payapplicationdetailss")
  public XfR save(@RequestBody PayApplicationDetails payApplicationDetails) {
     return XfR.ok(payApplicationDetailsServiceImpl.save(payApplicationDetails));
  }

  /**
   * 修改-传入修改后的全部数据付款申请单明细
   * @param payApplicationDetails 付款申请单明细
   * @return XfR
   */
  @PutMapping("/payapplicationdetailss/{id}")
  public XfR putUpdate(@RequestBody PayApplicationDetails payApplicationDetails,@PathVariable Long id) {
      payApplicationDetails.setId(id);
      return XfR.ok(payApplicationDetailsServiceImpl.updateById(payApplicationDetails));
  }

  /**
   * 修改-传入修改的数据付款申请单明细
   * @param payApplicationDetails 付款申请单明细
   * @return XfR
   */
  @PatchMapping("/payapplicationdetailss/{id}")
  public XfR patchUpdate(@RequestBody PayApplicationDetails payApplicationDetails,@PathVariable Long id) {
      PayApplicationDetails uppayApplicationDetails = payApplicationDetailsServiceImpl.getById(id);
      if(uppayApplicationDetails != null){
        uppayApplicationDetails = ObjectCopyUtils.copyProperties(payApplicationDetails,uppayApplicationDetails,true);
      }
      return XfR.ok(payApplicationDetailsServiceImpl.updateById(uppayApplicationDetails));
  }

  /**
   * 通过id删除付款申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/payapplicationdetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payApplicationDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/payapplicationdetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_application_details");
     params.put("request", condition);

     return XfR.ok(payApplicationDetailsServiceImpl.querys(params));
  }

}
