package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bug_close_reason
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum BugCloseReason {

    _1("1", "代码问题"),
    _2("2", "配置问题"),
    _3("3", "设计缺陷");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BugCloseReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BugCloseReason fromCode(String code) {
        return Stream.of(BugCloseReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
