package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * if_sync
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum IfSync {

    _0("0", "未同步"),
    _1("1", "已同步");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IfSync(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IfSync fromCode(String code) {
        return Stream.of(IfSync.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
