package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * milestone
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum Milestone {

    _1("1", "售前"),
    _2("2", "项目启动"),
    _3("3", "需求分析"),
    _4("4", "系统设计开发"),
    _5("5", "上线保驾"),
    _6("6", "转交运维");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Milestone(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Milestone fromCode(String code) {
        return Stream.of(Milestone.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
