package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operation_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum OperationType {

    _1("1", "修改"),
    _2("2", "提交"),
    _3("3", "评审"),
    _4("4", "排期"),
    _5("5", "上线"),
    _6("6", "验收"),
    _7("7", "作废"),
    _8("8", "编辑");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationType fromCode(String code) {
        return Stream.of(OperationType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
