package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reason_for_failure_acceptance
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum ReasonForFailureAcceptance {

    BUG问题("BUG问题", "BUG问题"),
    未满足需求("未满足需求", "未满足需求"),
    需求漫延("需求漫延", "需求漫延");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReasonForFailureAcceptance(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReasonForFailureAcceptance fromCode(String code) {
        return Stream.of(ReasonForFailureAcceptance.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
