package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reason_for_invalidation
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum ReasonForInvalidation {

    客户主动取消("客户主动取消", "客户主动取消"),
    替代解决("替代解决", "替代解决"),
    说服客户取消("说服客户取消", "说服客户取消");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReasonForInvalidation(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReasonForInvalidation fromCode(String code) {
        return Stream.of(ReasonForInvalidation.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
