package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * scene_categories
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum SceneCategories {

    _1("1", "进项（含影像）"),
    _2("2", "4.0销项"),
    _3("3", "协同"),
    _4("4", "3.0销项"),
    _5("5", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SceneCategories(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SceneCategories fromCode(String code) {
        return Stream.of(SceneCategories.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
