package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum Status {

    _0("0", "草稿"),
    _1("1", "待评审"),
    _2("2", "已通过"),
    _3("3", "已排期"),
    _4("4", "已上线"),
    _5("5", "已完成"),
    _6("6", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code) {
        return Stream.of(Status.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
