package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_environment
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum TaskEnvironment {

    _1("1", "SIT"),
    _2("2", "UAT"),
    _3("3", "生产");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskEnvironment(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskEnvironment fromCode(String code) {
        return Stream.of(TaskEnvironment.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
