package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_scenario
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum TaskScenario {

    _2("2", "范围内迭代"),
    _3("3", "需求变更"),
    _5("5", "新需求-CR"),
    _6("6", "新需求-免费"),
    _7("7", "功能问题"),
    _8("8", "性能问题"),
    _9("9", "接口问题"),
    _10("10", "任务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskScenario(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskScenario fromCode(String code) {
        return Stream.of(TaskScenario.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
