package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * time_task
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum TimeTask {

    TIME_TASK1("timeTask1", "定时同步客户、分期配置"),
    TIME_TASK2("timeTask2", "定时同步项目&分期&chargeCode"),
    TIME_TASK_ALL("timeTaskAll", "定时任务全局总开关");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TimeTask(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TimeTask fromCode(String code) {
        return Stream.of(TimeTask.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
