package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * type_of_value
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum TypeOfValue {

    _1("1", "操作类"),
    _2("2", "业务类"),
    _3("3", "管控类"),
    _4("4", "金融类"),
    _5("5", "政策类"),
    _6("6", "内部管理类");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TypeOfValue(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TypeOfValue fromCode(String code) {
        return Stream.of(TypeOfValue.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
