package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * valuable_or_not
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum ValuableOrNot {

    _1("1", "降本增效"),
    _2("2", "营销创收"),
    _3("3", "新政策/新技术趋势"),
    _4("4", "降低交付接入成本"),
    _5("5", "降case"),
    _6("6", "降低云砺管理成本");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ValuableOrNot(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ValuableOrNot fromCode(String code) {
        return Stream.of(ValuableOrNot.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
