package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * value_secondary_classification
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum ValueSecondaryClassification {

    _1("1", "展示/查询/文案等"),
    _2("2", "导入/导出/编辑等"),
    _3("3", "产品版本差异补齐"),
    _4("4", "新场景"),
    _5("5", "集成接口"),
    _6("6", "迁移升级"),
    _7("7", "产品版本差异补齐"),
    _8("8", "报表统计"),
    _9("9", "业务规则"),
    _10("10", "审批"),
    _11("11", "审计"),
    _12("12", "产品版本差异补齐"),
    _13("13", "数电国税基础能力"),
    _14("14", "数电产品定制能力"),
    _15("15", "其他政策"),
    _16("16", "内部降case"),
    _17("17", "内部对账"),
    _18("18", "内部运维"),
    _19("19", "数据增值"),
    _20("20", "资金节约效益");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ValueSecondaryClassification(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ValueSecondaryClassification fromCode(String code) {
        return Stream.of(ValueSecondaryClassification.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
