package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * yes_or_no
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public enum YesOrNo {

    _1("1", "是"),
    _2("2", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YesOrNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesOrNo fromCode(String code) {
        return Stream.of(YesOrNo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
