package com.xforceplus.ultraman.app.psccreqmgmt.metadata.validator;

import com.xforceplus.ultraman.app.psccreqmgmt.metadata.validator.annotation.CheckUltramanBool;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public class UltramanBoolConstraintValidator implements ConstraintValidator<CheckUltramanBool, String> {

    private final String MSG_FORMAT = "value must be 'true' or 'false' ";

    private final String TRUE_STR = "true";

    private final String FALSE_STR = "false";

    @Override
    public void initialize(CheckUltramanBool constraintAnnotation) {}

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = Arrays.asList(TRUE_STR, FALSE_STR).contains(value);

        if(!isValid) {
            unValidMsg(context);
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT))
                .addConstraintViolation();
    }
}
